#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

PyObject* scriptsdll_getvehicleoccupantcount(PyObject *self, PyObject *args)
{
	int id, count;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.Get_Vehicle_Occupant_Count().\n Bad argument(s)?\n");
        return NULL;
	}
	count = Get_Vehicle_Occupant_Count(Commands->Find_Object(id));
	return Py_BuildValue("i", count);
}

PyObject* scriptsdll_getvehicleoccupant(PyObject *self, PyObject *args)
{
	int id, seat, occupant;

	if (!PyArg_ParseTuple(args, "ii", &id, &seat))
	{
		printf("\nError occured inside scriptsdll.Get_Vehicle_Occupant().\n Bad argument(s)?\n");
        return NULL;
	}
	occupant = Helper::Get_ID(Get_Vehicle_Occupant(Commands->Find_Object(id), seat));
	return Py_BuildValue("i", occupant);
}

PyObject* scriptsdll_getvehicledriver(PyObject *self, PyObject *args)
{
	int id, driver;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.Get_Vehicle_Driver().\n Bad argument(s)?\n");
        return NULL;
	}
	driver = Helper::Get_ID(Get_Vehicle_Driver(Commands->Find_Object(id)));
	return Py_BuildValue("i", driver);
}

PyObject* scriptsdll_getvehiclegunner(PyObject *self, PyObject *args)
{
	int id, gunner;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.Get_Vehicle_Gunner().\n Bad argument(s)?\n");
        return NULL;
	}
	gunner = Helper::Get_ID(Get_Vehicle_Gunner(Commands->Find_Object(id)));
	return Py_BuildValue("i", gunner);
}

PyCFunction* scriptsdll_forceoccupantexit(PyObject *self, PyObject *args)
{
	int id, seat;

	if (!PyArg_ParseTuple(args, "ii", &id, &seat))
	{
		printf("\nError occured inside scriptsdll.Force_Occupant_Exit().\n Bad argument(s)?\n");
        return NULL;
	}
	Force_Occupant_Exit(Commands->Find_Object(id), seat);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_forceoccupantsexit(PyObject *self, PyObject *args)
{
	int id;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.Force_Occupants_Exit().\n Bad argument(s)?\n");
        return NULL;
	}
	Force_Occupants_Exit(Commands->Find_Object(id));
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getvehiclereturn(PyObject *self, PyObject *args)
{
	int id, returnid;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.Get_Vehicle_Return().\n Bad argument(s)?\n");
        return NULL;
	}
	returnid = Helper::Get_ID(Get_Vehicle_Return(Commands->Find_Object(id)));
	Py_INCREF(Py_None);
	return Py_BuildValue("i", returnid);
}